#!/bin/zsh

# to make the script fail safely
set -euo pipefail


out=${1:-output}

echo -e "" > $out

echo `date` | tee -a $out
echo "" >> $out
echo "Below is the feedback and provisional marks for your CW 4 submission." >> $out
echo "Please note all marks are provisional until ratified by the" >> $out
echo "assessment board -- this is not an official results transcript." >> $out
echo "" >> $out

echo "The feedback for your submission for cw04.sc" >> $out
echo "" >> $out

# marks for CW 4
marks=$(( 0.0 ))

# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" amm -s "$1" 2> c$out 1> c$out)
}

# functional tests

function scala_assert {
  rm -rf /Users/cu/.ammonite/cache/3.*/* 2> /dev/null ;  
  (ulimit -t 30; JAVA_OPTS="-Xmx1g -XX:MaxJavaStackTraceDepth=10" amm -s "$1" 1>> $out 2>> $out)
}

function scala_fail {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g -XX:MaxJavaStackTraceDepth=10" amm -s "$1" 1>> $out 2>> $out)
}


### compilation test

echo -e "0) cw04.sc compiles?" | tee -a $out

if (scala_compile "c.sc")
then
    echo -e "    --> yes cw04.sc compiles\n" | tee -a $out
    tsts=$(( 0 ))
else
    echo -e "    --> AMM DID NOT compile cw04.sc\n" | tee -a $out
    cat c$out | tee -a $out
    tsts=$(( 1 ))
fi

### fib.j test
echo >> $out
#echo -e "\n\n\n" >> $out

if [ $tsts -eq 0 ]
then
    echo -e "1.1) fib.j is not empty?" | tee -a $out

    if [ -s fib.j ]
    then
        echo -e "  --> success" | tee -a $out
        tstsA=$(( 0 ))
    else
        echo -e "  --> FAIL\n" | tee -a $out
        tstsA=$(( 1 ))
    fi
fi

echo >> $out

if [ $tstsA -eq 0 ]
then
    echo -e "1.2) Generating a class-file for fib.j:" | tee -a $out
    echo -e "   java -jar jasmin.jar fib.j\n" | tee -a $out

    java -jar /Users/cu/jasmin.jar fib.j 1> /dev/null 2> outj

    if [ -s outj ]
    then
        echo -e "  --> The jasmin assembler generated the following error message:\n" | tee -a $out
        cat outj >> $out
    else
	echo -e "   --> success (+ 5.0 Marks)\n" | tee -a $out
        marks=$(( marks + 5.0 ))
    fi
fi

### for test
echo >> $out
#echo -e "\n\n\n" >> $out

if [ $tsts -eq 0 ]
then
    echo -e "2.1) Generating j-file for the file:\n" | tee -a $out
    cat "for.while" | pr -to10 >> $out
    echo >> $out
    cat cw04.sc c1_add.sc > cw041_add.sc
    
    if (scala_assert "c1.sc")
    then
        echo -e "  --> success" | tee -a $out
        tstsB=$(( 0 ))
    else
        echo -e "  --> FAIL\n" | tee -a $out
        cat c$out >> $out
	tail -25 $out | pr -to10
        tstsB=$(( 1 ))
    fi
fi

echo >> $out

if [ $tstsB -eq 0 ]
then
    echo -e "2.2) Generating a class-file for this file:" | tee -a $out
    echo -e "   java -jar jasmin.jar for.j\n" | tee -a $out
    java -jar /Users/cu/jasmin.jar for.j 1> /dev/null 2> outj

    if [ -s outj ]
    then
        echo -e "  --> The jasmin assembler generated the following error message:\n" | tee -a $out
        cat outj >> $out
	tstsB=$(( 1 ))
    else
	echo -e "   --> success\n" | tee -a $out
	tstsB=$(( 0 ))
    fi
fi

if [ $tstsB -eq 0 ]
then
    echo -e "2.3) Running for.j" | tee -a $out
    if (scala_assert "c2.sc")
    then
        echo -e "  --> success (+ 5.0 Marks)\n" | tee -a $out
	marks=$(( marks + 5.0 ))
    else
        echo -e "  --> FAIL\n" | tee -a $out
	tail -25 $out | pr -to10
        cat c$out >> $out
    fi
fi

##############################

### break test
echo >> $out
#echo -e "\n\n\n" >> $out

if [ $tsts -eq 0 ]
then
    echo -e "3.1) Generating j-file for the file:\n" | tee -a $out
    cat "br.while" | pr -to10 >> $out
    echo >> $out
    cat cw04.sc c1_add.sc > cw041_add.sc
    
    if (scala_assert "c3.sc")
    then
        echo -e "  --> success" | tee -a $out
        tstsC=$(( 0 ))
    else
        echo -e "  --> FAIL\n" | tee -a $out
        cat c$out >> $out
	tail -25 $out | pr -to10
        tstsC=$(( 1 ))
    fi
fi

echo >> $out

if [ $tstsC -eq 0 ]
then
    echo -e "3.2) Generating a class-file for this file:" | tee -a $out
    echo -e "   java -jar jasmin.jar br.j\n" | tee -a $out
    java -jar /Users/cu/jasmin.jar br.j 1> /dev/null 2> outj

    if [ -s outj ]
    then
        echo -e "  --> The jasmin assembler generated the following error message:\n" | tee -a $out
        cat outj >> $out
	tstsC=$(( 1 ))
    else
	echo -e "   --> success\n" | tee -a $out
	tstsC=$(( 0 ))
    fi
fi

if [ $tstsC -eq 0 ]
then
    echo -e "3.3) Running br.j" | tee -a $out
    if (scala_assert "c4.sc")
    then
        echo -e "  --> success (+ 5.0 Marks)\n" | tee -a $out
	marks=$(( marks + 5.0 ))
    else
        echo -e "  --> FAIL\n" | tee -a $out
	tail -25 $out | pr -to10
        cat c$out >> $out
    fi
fi






echo >> $out

## final marks
echo >> $out
echo "Overall mark for CW 4" | tee -a $out
printf " %0.2f\n" $marks | tee -a $out



