package app

import scalatags.Text.all._
import scala.util.Random


object MinimalApplication extends cask.MainRoutes{

  val bootstrap = "https://stackpath.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.css"

  var x = Random.between(0, 7)
  var y = Random.between(0, 7) 
  var z = Random.between(0, 7) 

  abstract class Answer
  case object No extends Answer
  case object Correct extends Answer
  case class Wrong(n: Int) extends Answer

  var ans : Answer = No
  var cnt = 1

  val heart = raw("&#10084;&#65039;")
  val unicorn = raw("&#129412;")

  var nms = List("Christiane", "Sebastian")

  @cask.get("/")
  def hello() = 
      doctype("html")(
      html(
        head(link(rel := "stylesheet", href := bootstrap)), 
        body(
          div(cls := "container")( 
            //h1(s"Hello ${nms((cnt / 3) % 2)}!"), 
            h1(s"Hello Christiane"),  
            h1(s"$x + $y = ??"),  
	    ans match {
              case No => ""
              case Correct => i(color.green)("Correct!")
              case Wrong(n) => i(color.red)(s"$n is wrong!")
	    },
            form(action := "/", method := "post")(
	      frag(
		for (i <- 0 to 12) yield button(`type` := "submit", name := "name", value := i.toString)(i.toString)  
              )
            ),
            frag(
              for (i <- 0 until cnt) yield 
                if ((i + 1) % 10 != 0) heart else unicorn
            )
          )
        )
      )
  )

  @cask.postForm("/")
  def answer(name: String) = {
    if (x + y == name.toInt) {
      ans = Correct
      x = Random.between(0, 7)
      y = Random.between(0, 7)
      z = Random.between(0, 7)
      cnt = cnt + 1
    }
    else 
      ans = Wrong(name.toInt)
    hello()
  }

  initialize()
}
