// Detokenising the ouput of Tokeniser
//=====================================
//
// call with 
//
//     scala detokenise.scala fib.tks
//
//     scala detokenise.scala loops.tks

object Detokenise {

import java.io._

abstract class Token extends Serializable 
case object T_SEMI extends Token
case object T_LPAREN extends Token
case object T_RPAREN extends Token
case class T_ID(s: String) extends Token
case class T_OP(s: String) extends Token
case class T_NUM(n: Int) extends Token
case class T_KWD(s: String) extends Token
case class T_STR(s: String) extends Token

def deserialise[T](fname: String) : T = {
  val in = new ObjectInputStream(new FileInputStream(fname))
  val data = in.readObject.asInstanceOf[T]
  in.close
  data
}

def main(args: Array[String]) = {
  val fname = args(0)
  val tks = deserialise[List[Token]](fname)
  println(s"Reading back from ${fname}:\n${tks.mkString("\n")}")  
}


}