def concat(A: Set[String], B: Set[String]) : Set[String] =
  for (x <-A ; y <- B) yield x ++ y

def pow(A: Set[String], n: Int) : Set[String] = n match {
  case 0 => Set("")
  case n => concat(A, pow(A, n- 1))
}

val A = Set("a", "b", "c", "d")
pow(A, 4).size                            // -> 256

val B = Set("a", "b", "c", "")
pow(B, 4).size                            // -> 121



val B2 = Set("a", "b", "c", "")
pow(B2, 3).size                           // -> 40

val C = Set("a", "b", "")
pow(C, 2)
pow(C, 2).size                            // -> 7

pow(C, 3)
pow(C, 3).size                            // -> 15


val A = Set("a", "b", "c", "d")
pow(A, 4).size   

val A = Set("a", "b", "c")
pow(A, 5).size   

val A = Set("a", "b", "")
pow(A, 5).size   
