#!/usr/bin/env amm

val files = Seq("hw01.tex",
	        "hw02.tex",
	        "hw03.tex",
	        "hw04.tex",
	        "hw05.tex",
                "hw06.tex",
	        "hw07.tex",
	        "hw08.tex",
	        "hw09.tex")

val pdf_files = files.map(s => s.stripSuffix("tex") ++ "pdf")


@main
def make() = {
  for (f <- files) {
    println(s"Processing $f ...")
    os.proc("lualatex", f).call(stdout = os.Inherit, stdin = os.Inherit)
  }
}

@main
def make_sols() = {
  for (f <- files) {
    val old_pdf = f.stripSuffix(".tex") ++ ".pdf"
    val new_pdf = f.stripSuffix(".tex") ++ "-sol.pdf"
    println(s"Processing $f -> $new_pdf ...")
    os.proc("lualatex", f, "sol").call(stdout = os.Inherit, stdin = os.Inherit)
    os.move.over(os.pwd / old_pdf, os.pwd / new_pdf)
  }
}

@main
def hg() = {
  println(os.proc("hg", "commit", "-m texupdate", files ++ pdf_files).call())
  println(os.proc("hg", "push").call())
}
