
import scalatags.Text.all._
import scalatags.Text._
import scala.util.Random



object MinimalApplication extends cask.MainRoutes{

  abstract class Rexp 
  case object ZERO extends Rexp
  case object ONE extends Rexp
  case class CHAR(c: Char) extends Rexp
  case class ALT(r1: Rexp, r2: Rexp) extends Rexp 
  case class SEQ(r1: Rexp, r2: Rexp) extends Rexp 
  case class STAR(r: Rexp) extends Rexp 

  val evil2 = ALT(SEQ(STAR(STAR(CHAR('a'))), CHAR('b')), ONE)

  def pp(r: Rexp) : TypedTag[String] = r match {
    case CHAR(c) => li(code(c.toString))
    case ALT(r1, r2) => li(code("+"), ul(pp(r1), pp(r2)))
    case SEQ(r1, r2) => li(code("o"), ul(pp(r1), pp(r2)))
    case STAR(r1) => li(code("*"), ul(pp(r1)))
    case ZERO => li(code("0"))
    case ONE => li(code(div(style :="line-height:50%")
                           ("1",br, 
                            div(color:="blue", fontSize:=6.pt)("0101010101"))))
  } 

  abstract class ARexp 
  case object AZERO extends ARexp
  case class AONE(bs: String) extends ARexp
  case class ACHAR(bs:String, c: Char) extends ARexp
  case class AALT(bs:String, r1: ARexp, r2: ARexp) extends ARexp 
  case class ASEQ(bs: String,r1: ARexp, r2: ARexp) extends ARexp 
  case class ASTAR(bs:String,r: ARexp) extends ARexp 


  def node(s: String, bs: String) = {
    if (bs == "")
      code(div(div(style :="line-height:75%")(s, br, div(color:="blue", fontSize:=6.pt)(raw("&nbsp")))))
    else
      code(div(div(style :="line-height:75%")(s, br, div(color:="blue", fontSize:=6.pt)(bs))))
  }
  

  val aevil2 = AALT("", ASEQ(" ",ASTAR("111",ASTAR("0",ACHAR("00",'a'))), ACHAR("00",'b')), AONE("01"))

  def ppa(r: ARexp) : TypedTag[String] = r match {
    case ACHAR(bs, c) => li(node(c.toString, bs))
    case AALT(bs, r1, r2) => li(node("+", bs), ul(ppa(r1), ppa(r2)))
    case ASEQ(bs, r1, r2) => li(node("o", bs), ul(ppa(r1), ppa(r2)))
    case ASTAR(bs, r1) => li(node("*", bs), ul(ppa(r1)))
    case AZERO => li(node("0", ""))
    case AONE(bs) => li(node("1", bs))
  } 





  val bootstrap = "https://stackpath.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.css"

  var cnt = 0

  @cask.get("/")
  def hello() = 
      doctype("html")(
      html(
        head(link(rel := "stylesheet", href := bootstrap),
             link(rel := "stylesheet", href := "static/style.css")), 
        body(
          div(cls := "container")( 
            h1(s"Hello"),
            ul(cls := "tree")(pp(evil2)),
	    ul(cls := "tree")(ppa(aevil2))
          )
        )
      )
    )

  @cask.postForm("/")
  def answer(name: String) = {
    cnt = cnt + 1
    hello()
  }

  //@cask.staticFiles("/static/")
  //def staticFileRoutes() = "static"

  @cask.staticResources("/static")
  def staticResourceRoutes() = "static"

  initialize()
}
