#!/bin/zsh

# to make the script fail safely
set -euo pipefail


out=${1:-output}

echo -e "" > $out

echo `date` | tee -a $out
echo "" >> $out
echo "Below is the feedback and provisional marks for your CW 5 submission." >> $out
echo "Please note all marks are provisional until ratified by the" >> $out
echo "assessment board -- this is not an official results transcript." >> $out
echo "" >> $out

echo "The feedback for your submission for cw05.sc" >> $out
echo "" >> $out

# marks for CW 5
marks=$(( 0.0 ))

# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" amm -s "$1" 2> c$out 1> c$out)
}

# functional tests
setopt no_nomatch

function scala_assert {
  rm -rf /Users/cu/.ammonite/cache/3.0.0-M2/* 1> /dev/null 2> /dev/null ;  
  (ulimit -t 300; JAVA_OPTS="-Xmx1g -XX:MaxJavaStackTraceDepth=10" amm -s "$1" 1>> $out 2>> $out)
}

function scala_fail {
  rm -rf /Users/cu/.ammonite/cache/3.0.0-M2/* 1> /dev/null 2> /dev/null ;  
  (ulimit -t 300; JAVA_OPTS="-Xmx1g -XX:MaxJavaStackTraceDepth=10" amm -s "$1" | tee -a $out)
}



### compilation test

echo -e "0) cw05.sc compiles?" | tee -a $out

if (scala_compile "c.sc")
then
    echo -e "  --> yes cw05.sc compiles\n" | tee -a $out
    tsts=$(( 0 ))
else
    echo -e "  --> AMM DID NOT compile cw05.sc\n" | tee -a $out
    cat c$out | tee -a $out
    tsts=$(( 1 ))
fi


### tokenise test

if [ $tsts -eq 0 ]
then
  echo -e "1) tokenise test\n" | tee -a $out
  cat cw05.sc c1_add.sc > cw05_add.sc
  if (scala_assert "c1.sc")     
  then
      echo -e "  --> success (+ 2.0 Marks)\n" | tee -a $out
      #cat $out | tee -a $out
      marks=$(( marks + 2.0 ))
  else
      echo -e "  --> FAILED\n" | tee -a $out
      cat $out | tee -a $out
  fi
fi

### parsing test

if [ $tsts -eq 0 ]
then
  echo -e "2) parsing test\n" | tee -a $out
  cat cw05.sc c2_add.sc > cw05_add.sc
  START=$(date +%s)
  
  if (scala_assert "c2.sc")     
  then
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo -e "  This test ran for $DIFF seconds" | tee -a $out
      echo -e "  --> success (+ 3.0 Marks)\n" | tee -a $out
      #cat $out | tee -a $out
      marks=$(( marks + 3.0 ))
  else
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo -e "  This test ran for $DIFF seconds" | tee -a $out
      echo -e "  --> FAILED\n" | tee -a $out
      cat $out | tee -a $out
  fi
fi

### mand test
echo >> $out
#echo -e "\n\n\n" >> $out


tstsB=$(( 1 ))

if [ $tsts -eq 0 ]
then
    echo -e "3.1) Generating ll-file for mand.fun:\n" | tee -a $out
    echo >> $out
    cat cw05.sc c3_add.sc > cw051_add.sc

    if (scala_assert "c3.sc")
    then
        echo -e "  --> success" | tee -a $out
        tstsB=$(( 0 ))
    else
        echo -e "  --> FAIL\n" | tee -a $out
        cat c$out >> $out
        tail -25 $out | pr -to10
        tstsB=$(( 1 ))
    fi
fi

if [ $tstsB -eq 0 ]
then
    echo -e "3.2) Running mand.ll and check its output" | tee -a $out
    if (scala_fail "c4.sc")
    then
        echo -e "  --> success (+ 12.0 Marks)\n" | tee -a $out
        marks=$(( marks + 12.0 ))
    else
        echo -e "  --> FAIL\n" | tee -a $out
	echo -e "  generated:" | tee -a $out
        cat "mand.ll" | pr -to10
        #cat c$out >> $out
    fi
fi

### mand test
echo >> $out
#echo -e "\n\n\n" >> $out


if [ $tsts -eq 0 ]
then
    echo -e "4.1) Generating ll-file for sqr.fun:\n" | tee -a $out
    echo >> $out
    cat cw05.sc c3_add.sc > cw051_add.sc

    if (scala_assert "c5.sc")
    then
        echo -e "  --> success" | tee -a $out
        tstsB=$(( 0 ))
    else
        echo -e "  --> FAIL\n" | tee -a $out
        cat c$out >> $out
        tail -25 $out | pr -to10
        tstsB=$(( 1 ))
    fi
fi

if [ $tstsB -eq 0 ]
then
    echo -e "4.2) Running sqr.ll and check its output" | tee -a $out
    if (scala_fail "c6.sc")
    then
        echo -e "  --> success (+ 6.0 Marks)\n" | tee -a $out
        marks=$(( marks + 6.0 ))
    else
        echo -e "  --> FAIL\n" | tee -a $out
	echo -e "  generated:" | tee -a $out
        cat "sqr.ll" | pr -to10
        #cat c$out >> $out
    fi
fi


if [ $tsts -eq 0 ]
then
    echo -e "5) Does main return an integer in mand.ll (define i32 @main() {...})? " | tee -a $out
    if (grep "define i32 @main()" "mand.ll" 1> /dev/null 2> /dev/null)
    then
        echo -e "  --> success (+ 2.0 Marks)\n" | tee -a $out
        marks=$(( marks + 2.0 ))
    else
        echo -e "  --> FAIL\n" | tee -a $out
        #tail -25 $out | pr -to10
        #cat c$out >> $out
    fi
fi


## final marks
echo >> $out
echo "Overall mark for CW 5" | tee -a $out
printf " %0.2f\n" $marks | tee -a $out



