// for testing tokenisation

import scala.util.{Try, Success, Failure}
import $file.cw05_add
import cw05_add._

// programs to test (and number of toplevel definitions)
val uprogs = List(("fact.fun",  5), 
                  ("hanoi.fun", 2),
		  ("mand.fun", 11), 
		  ("sqr.fun",   4)) 

for ((file, no) <- uprogs) {

  print(s"Testing Parsing of $file ")
  val str = os.read(os.pwd / file)
  

  Try(test_string(str).length) match {
    case Success(v) if v == no => println(s"--> Success. Parsed $no top-level definitions.")
    case Success(v) => println(s"--> Success? Parsed $v top-level definitions (should be $no).")// ; throw new Exception("Different")
    case Failure(e) => println(s"--> FAIL. Exception raised.") ; throw(e)
  }
}
