
def concat(A: Set[String], B: Set[String]) : Set[String] =
  for (x <- A ; y <- B) yield x ++ y

def pow(A: Set[String], n: Int) : Set[String] = n match {
  case 0 => Set("")
  case n => concat(A, pow(A, n - 1))
}



val A = Set("a", "b", "c", "d")
val B = Set("a", "b", "c", "")
pow(A, 4).size
pow(B, 4).size


