/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.CP;
import jas.ClassEnv;
import jas.CodeAttr;
import jas.Label;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;

public class CatchEntry {
    Label start_pc;
    Label end_pc;
    Label handler_pc;
    int start_off;
    int end_off;
    int handler_off;
    CP catch_cpe;

    public CatchEntry(Label start, Label end, Label handler, CP cat) {
        this.start_pc = start;
        this.end_pc = end;
        this.handler_pc = handler;
        this.catch_cpe = cat;
    }

    public CatchEntry(int start, int end, int handler, CP cat) {
        this.start_off = start;
        this.end_off = end;
        this.handler_off = handler;
        this.catch_cpe = cat;
    }

    void resolve(ClassEnv e) {
        if (this.catch_cpe != null) {
            e.addCPItem(this.catch_cpe);
        }
    }

    void write(ClassEnv e, CodeAttr ce, DataOutputStream out) throws IOException, jasError {
        if (this.start_pc != null && this.end_pc != null && this.handler_pc != null) {
            this.start_pc.writeOffset(ce, null, out);
            this.end_pc.writeOffset(ce, null, out);
            this.handler_pc.writeOffset(ce, null, out);
        } else {
            out.writeShort(this.start_off);
            out.writeShort(this.end_off);
            out.writeShort(this.handler_off);
        }
        if (this.catch_cpe != null) {
            out.writeShort(e.getCPIndex(this.catch_cpe));
        } else {
            out.writeShort(0);
        }
    }
}

