/*
 * Decompiled with CFR 0.152.
 */
package jasmin;

import jas.StackMap;
import jas.jasError;
import jasmin.ClassFile;
import jasmin.ScannerUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Main {
    public static final String version = "v2.4";
    public static final boolean DEBUG = false;
    private String dest_path = null;
    private String encoding = null;
    private boolean generate_linenum = false;
    private static final String help1 = "usage: jasmin [-d <outpath>] [-g] [-e <encoding>] <file> [<file> ...]\n";
    private static final String help2 = "           where   -g - autogenerate linenumbers\n                   -e - codepage for inputfile encoding\n                   -d - path for generated classfiles\n                file  - sourcefile (wildcards are allowed)\n";
    private static final String help3 = "   or: jasmin -version\n   or: jasmin -help";

    private static void unarg_option(String opt) {
        System.err.println("Invaid command line: option " + opt + " required argument");
        System.exit(-1);
    }

    private static void duplicate_option(String opt) {
        System.err.println("Duplicate option " + opt + " ignored");
    }

    public final void assemble(String fname) {
        File out_file = null;
        FileOutputStream outp = null;
        File file = new File(fname);
        ClassFile classFile = new ClassFile();
        String iocause = fname + ": file not found";
        try {
            FileInputStream fs = new FileInputStream(fname);
            InputStreamReader ir = this.encoding == null ? new InputStreamReader(fs) : new InputStreamReader((InputStream)fs, this.encoding);
            BufferedReader inp = new BufferedReader(ir);
            classFile.readJasmin(inp, file.getName(), this.generate_linenum);
            inp.close();
            if (classFile.errorCount() > 0) {
                System.err.println(fname + ": Found " + classFile.errorCount() + " errors");
                return;
            }
            String[] class_path = ScannerUtils.splitClassField(classFile.getClassName());
            String class_name = class_path[1];
            String dest_dir = this.dest_path;
            if (class_path[0] != null) {
                String class_dir = ScannerUtils.convertChars(class_path[0], "./", File.separatorChar);
                dest_dir = dest_dir != null ? dest_dir + File.separator + class_dir : class_dir;
            }
            iocause = class_name + ".class: file can't be created";
            if (dest_dir == null) {
                out_file = new File(class_name + ".class");
            } else {
                out_file = new File(dest_dir, class_name + ".class");
                File dest = new File(dest_dir);
                if (!dest.exists()) {
                    dest.mkdirs();
                }
                if (!dest.isDirectory()) {
                    throw new IOException("Cannot create directory");
                }
            }
            outp = new FileOutputStream(out_file);
            classFile.write(outp);
            outp.close();
            outp = null;
            System.out.println("Generated: " + out_file.getPath());
        }
        catch (FileNotFoundException e) {
            System.err.println(iocause);
            System.exit(-1);
        }
        catch (jasError e) {
            classFile.report_error("JAS Error: " + e.getMessage(), e.numTag);
        }
        catch (Exception e) {
            classFile.report_error(fname + ": exception - <" + e.getClass().getName() + "> " + e.getMessage() + ".");
        }
        if (classFile.errorCount() > 0) {
            System.err.println(fname + ": Found " + classFile.errorCount() + " errors");
            if (outp != null) {
                try {
                    outp.close();
                    out_file.delete();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public static void main(String[] args) {
        new Main().run(args);
    }

    public final void run(String[] args) {
        int i;
        String[] files = new String[args.length];
        int num_files = 0;
        if (args.length == 0) {
            System.err.println("usage: jasmin [-d <outpath>] [-g] [-e <encoding>] <file> [<file> ...]\n   or: jasmin -version\n   or: jasmin -help");
            System.exit(-1);
        }
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-help") || args[i].equals("-?")) {
                System.err.println("usage: jasmin [-d <outpath>] [-g] [-e <encoding>] <file> [<file> ...]\n           where   -g - autogenerate linenumbers\n                   -e - codepage for inputfile encoding\n                   -d - path for generated classfiles\n                file  - sourcefile (wildcards are allowed)\n   or: jasmin -version\n   or: jasmin -help");
                System.exit(0);
            }
            if (args[i].equals("-version")) {
                System.out.println("Jasmin version: v2.4");
                System.exit(0);
            }
            if (args[i].equals("-g")) {
                this.generate_linenum = true;
                continue;
            }
            if (args[i].equals("-d")) {
                if (++i >= args.length) {
                    Main.unarg_option("-d");
                }
                if (this.dest_path != null) {
                    Main.duplicate_option("-d");
                    continue;
                }
                this.dest_path = args[i];
                continue;
            }
            if (args[i].equals("-e")) {
                if (++i >= args.length) {
                    Main.unarg_option("-e");
                }
                if (this.encoding != null) {
                    Main.duplicate_option("-e");
                    continue;
                }
                this.encoding = args[i];
                continue;
            }
            files[num_files++] = args[i];
        }
        for (i = 0; i < num_files; ++i) {
            StackMap.reinit();
            this.assemble(files[i]);
        }
    }
}

