// for testing compilation
import scala.util.{Try, Success, Failure}

//println("TEST1")

val res = {
  if (os.exists(os.pwd / "mand.ll")) 
    os.proc("lli", "mand.ll").call(cwd = os.pwd, check = false)
  else throw new Exception("No CLASS file found")
}

//println("TEST2")

/*
if (res.exitCode != 0) {
  throw new Exception("Unsuccessful call")
}
*/

def pp(s1: String, s2: String) = {
  val s1a = s1.split("\n").toList
  val s2a = s2.split("\n").toList
  for (n <- 0 to (s1a.length - 1)) {
    println(s"|${s1a(n)}|")
    println(s">${Try(s2a(n)).getOrElse("")}<")
  }
}

//println("TEST3")

val out = os.read(os.pwd / "mand.out")

//println("TEST4")

Try(res.out.text()) match {
  case Success(v) if v == out => println(s"   Success. Printed out the correct picture.\n")
  case Success(v) => println(s"   Printed out wrong or no picture.\n${pp(v, out)}") ; throw new Exception("Wrong picture")
  case Failure(e) => println(s"   Fail. Printed ${res.out.text()} instead\n") ; throw(e)
}

