// for testing compilation
import scala.util.{Try, Success, Failure}


val res = {
  if (os.exists(os.pwd / "for.class")) 
    os.proc("java", "for").call(cwd = os.pwd)
  else if (os.exists(os.pwd / "for" / "for.class")) 
    os.proc("java", "for.for").call(cwd = os.pwd)
  else throw new Exception("No CLASS file found")
}

/*
Try(test_string(ffile, "for")) match {
  case Success(v) => Console.println(s"   Generated a j-file.")
  case Failure(e) => Console.println(s"   Exception raised.") ; throw(e)
}
*/

if (res.exitCode != 0) {
  throw new Exception("Unsuccessful call")
}

Try(res.out.text().replace("\n", "") == "234") match {
  case Success(v) => Console.println(s"   Success. Printed ${res.out.text().replace("\n", "")}.")
  case Failure(e) => Console.println(s"   Fail. Printed ${res.out.text()} instead of \"2,3,4\"\n") ; throw(e)
}


//println(res.out.text())


/*


// for testing compilation
import scala.util.{Try, Success, Failure}

import $file.cw041_add
import cw041_add._

val res = 
  if (os.exists(os.pwd / "for.class")) {

  } else if (os.exists(os.pwd / for" / "for.class")) {

  } else 
    


val ffile = os.read(os.pwd / "for.while")

Try(test_string(ffile, "for")) match {
  case Success(v) => Console.println(s"   Generated a j-file.")
  case Failure(e) => Console.println(s"   Exception raised.") ; throw(e)
}


*/
